/*----------------------------------------------------------------------------
 * Name:    timer.c
 * Purpose:
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include	"timer.h"
#include	"ht32_cm0plus_misc.h"

timer_operate_t timer_operate;
static u32	Time1us_clock;

/*****************************************************************************************************
* @brief  Configures SysTick
* @retval None
*******************************************************************************************************/
void SystickConfigure(void)
{
	Time1us_clock = (SystemCoreClock / 1000000UL);

	SYSTICK_ClockSourceConfig(SYSTICK_SRC_STCLK);       	// Default : CK_SYS/8
	SYSTICK_SetReloadValue(SystemCoreClock / 8 / 1000); 	// (CK_SYS/8/1000) = 1ms on chip
	SYSTICK_IntConfig(ENABLE);                          	// Enable SYSTICK Interrupt

	/* Enable the SysTick Counter */
	SYSTICK_CounterCmd(SYSTICK_COUNTER_CLEAR);
	SYSTICK_CounterCmd(SYSTICK_COUNTER_ENABLE);
}
/*********************************************************************************************************//**
 * @brief   This function handles SysTick Handler.
 * @retval  None
 ************************************************************************************************************/
void SysTick_Handler(void)
{
	timer_operate.bits.t1ms = TRUE;
  /*--------------------------------------------------------------------------------------------------------*/
  /* DSB instruction is added in this function to ensure the write operation which is for clearing interrupt*/
  /* flag is actually completed before exiting ISR. It prevents the NVIC from detecting the interrupt again */
  /* since the write register operation may be pended in the internal write buffer of Cortex-Mx when program*/
  /* has exited interrupt routine. This DSB instruction may be masked if this function is called in the     */
  /* beginning of ISR and there are still some instructions before exiting ISR.                             */
  /*--------------------------------------------------------------------------------------------------------*/
  __DSB();
}
/*****************************************************************************************************
* @brief  delay n*ms
* @retval None
*******************************************************************************************************/
void timer_counter_us(unsigned long n)
{
	RSTCU_PeripReset_TypeDef RSTCUReset = {{0}};	

//	HT_BFTM0->CR &= ~BFTM_CEN;      	/* BFTM1 is disable */	
//	NVIC_DisableIRQ(BFTM0_IRQn);     /* Disable NVIC Basic Function Timer1 interrupt */
   RSTCUReset.Bit.BFTM0 = 1;
	RSTCU_PeripReset(RSTCUReset, ENABLE);	
	timer_operate.bits.tc_finish = FALSE;	

	do
	{
		HT_BFTM0->CR = ((1UL << 0) |     /* Compare Match Interrupt is enabled */
							(1UL << 1) |		/* Counter operates in one shot mode */
							(0UL << 2) );    /* BFTM is disabled */
		HT_BFTM0->CMP = Time1us_clock * n;
		HT_BFTM0->CNTR = 0;
		HT_BFTM0->SR = 0UL;					/* clear Compare Match Interrupt Flag */
		HT_BFTM0->CR |= BFTM_CEN;      	/* BFTM is enable */
	}while(!(HT_BFTM0->CR & BFTM_CEN));
	NVIC_EnableIRQ(BFTM0_IRQn);      /* Enable NVIC Basic Function Timer1 interrupt */
}
/*********************************************************************************************************//**
 * @brief  BFTM1 interrupt.
 * @retval None
 ************************************************************************************************************/
void BFTM0_IRQHandler(void)
{
	HT_BFTM0->SR = 0UL;					/* clear Compare Match Interrupt Flag */
	HT_BFTM0->CR &= ~BFTM_CEN;     	/* BFTM is disable */
	NVIC_DisableIRQ(BFTM0_IRQn);     /* Disable NVIC Basic Function Timer1 interrupt */
	timer_operate.bits.tc_finish = TRUE;
  /*--------------------------------------------------------------------------------------------------------*/
  /* DSB instruction is added in this function to ensure the write operation which is for clearing interrupt*/
  /* flag is actually completed before exiting ISR. It prevents the NVIC from detecting the interrupt again */
  /* since the write register operation may be pended in the internal write buffer of Cortex-Mx when program*/
  /* has exited interrupt routine. This DSB instruction may be masked if this function is called in the     */
  /* beginning of ISR and there are still some instructions before exiting ISR.                             */
  /*--------------------------------------------------------------------------------------------------------*/
  __DSB();
}
/*****************************************************************************************************
* @brief  delay n*(unit * 1us)
* @retval None
*******************************************************************************************************/
void delay_xxus(unsigned long unit,unsigned long n)
{
	HT_BFTM1->CR = ((0UL << 0) |     /* Compare Match Interrupt is disabled */
						 (1UL << 1) |		/* Counter operates in one shot mode */
						 (0UL << 2) );    /* BFTM1 disable */
	HT_BFTM1->CMP = (Time1us_clock * unit) * n;
	HT_BFTM1->CNTR = 0;
	HT_BFTM1->SR = 0UL;					/* clear Compare Match Interrupt Flag */
	HT_BFTM1->CR |= BFTM_CEN;      	/* BFTM1 is enable */
	while( !(HT_BFTM1->SR & BFTM_MIF));
	HT_BFTM1->CR &= ~BFTM_CEN;      	/* BFTM1 is disable */
	HT_BFTM1->SR = 0UL;					/* clear Compare Match Interrupt Flag */
}
